/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights;

import dev.lambdaurora.lambdynlights.DynamicLightsConfig;
import dev.lambdaurora.lambdynlights.DynamicLightsMode;
import dev.lambdaurora.lambdynlights.api.DynamicLightsContext;
import dev.lambdaurora.lambdynlights.api.DynamicLightsInitializer;
import dev.lambdaurora.lambdynlights.api.behavior.DynamicLightBehavior;
import dev.lambdaurora.lambdynlights.api.behavior.DynamicLightBehaviorManager;
import dev.lambdaurora.lambdynlights.api.entity.EntityLightSourceManager;
import dev.lambdaurora.lambdynlights.api.item.ItemLightSourceManager;
import dev.lambdaurora.lambdynlights.compat.CompatLayer;
import dev.lambdaurora.lambdynlights.engine.DynamicLightBehaviorSources;
import dev.lambdaurora.lambdynlights.engine.DynamicLightingEngine;
import dev.lambdaurora.lambdynlights.engine.TickMode;
import dev.lambdaurora.lambdynlights.engine.scheduler.ChunkRebuildScheduler;
import dev.lambdaurora.lambdynlights.engine.scheduler.ChunkRebuildStatus;
import dev.lambdaurora.lambdynlights.engine.source.DeferredDynamicLightSource;
import dev.lambdaurora.lambdynlights.engine.source.DynamicLightSource;
import dev.lambdaurora.lambdynlights.engine.source.EntityDynamicLightSource;
import dev.lambdaurora.lambdynlights.engine.source.EntityDynamicLightSourceBehavior;
import dev.lambdaurora.lambdynlights.gui.DevModeGui;
import dev.lambdaurora.lambdynlights.platform.Platform;
import dev.lambdaurora.lambdynlights.platform.PlatformProvider;
import dev.lambdaurora.lambdynlights.resource.LightSourceLoader;
import dev.lambdaurora.lambdynlights.resource.entity.EntityLightSources;
import dev.lambdaurora.lambdynlights.resource.item.ItemLightSources;
import dev.lambdaurora.lambdynlights.util.BoundingBoxUtils;
import dev.lambdaurora.lambdynlights.util.DynamicLightBehaviorDebugRenderer;
import dev.lambdaurora.lambdynlights.util.DynamicLightDebugRenderer;
import dev.lambdaurora.lambdynlights.util.DynamicLightLevelDebugRenderer;
import dev.lambdaurora.lambdynlights.util.DynamicLightSectionDebugRenderer;
import dev.lambdaurora.spruceui.SpruceTexts;
import dev.yumi.mc.core.api.CrashReportEvents;
import dev.yumi.mc.core.api.ModContainer;
import dev.yumi.mc.core.api.YumiMods;
import dev.yumi.mc.core.api.entrypoint.EntrypointContainer;
import dev.yumi.mc.core.api.entrypoint.client.ClientModInitializer;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import net.minecraft.class_10209;
import net.minecraft.class_10748;
import net.minecraft.class_11631;
import net.minecraft.class_124;
import net.minecraft.class_129;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_4184;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_7225;
import net.minecraft.class_7452;
import net.minecraft.class_746;
import net.minecraft.class_761;
import net.minecraft.class_765;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiStatus.Internal
public class LambDynLights
implements ClientModInitializer,
DynamicLightsContext {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"LambDynamicLights");
    public static final LambDynLights INSTANCE = new LambDynLights();
    public static final class_304 TOGGLE_FPS_DYNAMIC_LIGHTING = new class_304("lambdynlights.key.toggle_fps_dynamic_lighting", class_3675.class_307.field_1668, -1, class_304.class_11900.field_62556);
    public final DynamicLightsConfig config = new DynamicLightsConfig(this);
    private final LightSourceLoader.ApplicationPredicate.Pending lightSourceApplicationPredicate = new LightSourceLoader.ApplicationPredicate.Pending();
    private final ItemLightSources itemLightSources = new ItemLightSources(this.lightSourceApplicationPredicate);
    private final EntityLightSources entityLightSources = new EntityLightSources(this.itemLightSources, this.lightSourceApplicationPredicate);
    private final DynamicLightBehaviorSources dynamicLightBehaviorSources = new DynamicLightBehaviorSources(this);
    public final DynamicLightingEngine engine = new DynamicLightingEngine(this.config);
    private final Set<DynamicLightSource> dynamicLightSources = new HashSet<DynamicLightSource>();
    private final Set<DynamicLightSource> toAdd = new HashSet<DynamicLightSource>();
    private final List<DynamicLightSource> toClear = new ArrayList<DynamicLightSource>();
    private final ReentrantReadWriteLock lightSourcesLock = new ReentrantReadWriteLock();
    private final DynamicLightDebugRenderer.SectionRebuild sectionRebuildDebugRenderer = new DynamicLightDebugRenderer.SectionRebuild(this);
    public final @Unmodifiable List<DynamicLightDebugRenderer> opaqueDebugRenderers = List.of(new DynamicLightBehaviorDebugRenderer(this, this.dynamicLightSources), new DynamicLightLevelDebugRenderer(this));
    public final @Unmodifiable List<DynamicLightDebugRenderer> transparentDebugRenderers = List.of(this.sectionRebuildDebugRenderer, new DynamicLightSectionDebugRenderer(this));
    private ChunkRebuildScheduler chunkRebuildScheduler;
    private int tick = 0;
    private TickMode minimumTickMode = TickMode.REAL_TIME;
    private boolean disableTicking = false;
    boolean shouldForceRefresh = false;
    private int dynamicLightSourcesCount = 0;

    private LambDynLights() {
    }

    public void onInitializeClient(ModContainer mod) {
        LambDynLights.log(LOGGER, "Initializing LambDynamicLights...");
        this.config.load();
        DevModeGui.init();
        CrashReportEvents.CREATE.register(report -> {
            class_129 category = report.method_562("Dynamic Lighting");
            category.method_578("Mode", (Object)this.config.getDynamicLightsMode().getName());
            category.method_578("Dynamic Light Sources", (Object)this.dynamicLightSourcesCount);
            category.method_578("Spatial Hash Occupancy", (Object)"%d / %d".formatted(this.engine.getLastEntryCount(), 1024));
        });
        Platform platform = ((PlatformProvider)((EntrypointContainer)YumiMods.get().getEntrypoints("lambdynlights:platform_provider", PlatformProvider.class).getFirst()).value()).getPlatform(mod);
        this.lightSourceApplicationPredicate.set(platform.getLightSourceLoaderApplicationPredicate());
        platform.registerReloader(this.itemLightSources);
        platform.registerReloader(this.entityLightSources);
        platform.getTagLoadedEvent().register(this::onTagsLoaded);
        this.registerDebugEntries();
        this.initializeApi();
    }

    private void initializeApi() {
        this.invokeInitializers("lambdynlights:initializer");
        this.invokeInitializers("dynamiclights");
    }

    private void invokeInitializers(String entrypointKey) {
        YumiMods.get().getEntrypoints(entrypointKey, DynamicLightsInitializer.class).stream().map(EntrypointContainer::value).forEach(this::invokeInitializer);
    }

    private void invokeInitializer(DynamicLightsInitializer initializer) {
        initializer.onInitializeDynamicLights((DynamicLightsContext)this);
    }

    public ItemLightSourceManager itemLightSourceManager() {
        return this.itemLightSources;
    }

    public EntityLightSourceManager entityLightSourceManager() {
        return this.entityLightSources;
    }

    public DynamicLightBehaviorManager dynamicLightBehaviorManager() {
        return this.dynamicLightBehaviorSources;
    }

    public boolean shouldTick(EntityDynamicLightSource entity) {
        if (this.disableTicking) {
            return false;
        }
        TickMode effectiveMode = this.minimumTickMode.min(this.getBaseTickMode(entity.getDynamicLightX(), entity.getDynamicLightY(), entity.getDynamicLightZ()));
        if (effectiveMode == TickMode.REAL_TIME) {
            return true;
        }
        return this.tick % effectiveMode.delay() == entity.getDynamicLightId() % effectiveMode.delay();
    }

    public boolean shouldTick(DeferredDynamicLightSource source) {
        if (this.disableTicking) {
            return false;
        }
        TickMode effectiveMode = this.minimumTickMode.min(BoundingBoxUtils.forAllPoints(source.behavior().getBoundingBox(), this::getBaseTickMode).stream().reduce(TickMode.BACKGROUND, TickMode::max));
        if (effectiveMode == TickMode.REAL_TIME) {
            return true;
        }
        return this.tick % effectiveMode.delay() == source.getDynamicLightId() % effectiveMode.delay();
    }

    private TickMode getBaseTickMode(double x, double y, double z) {
        TickMode mode = TickMode.REAL_TIME;
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        Vector3f planeNormal = camera.method_19335();
        class_243 planeOrigin = camera.method_19326();
        Vector3f planeOriginToEntity = new Vector3f((float)(x - planeOrigin.field_1352), (float)(y - planeOrigin.field_1351), (float)(z - planeOrigin.field_1350));
        float signedDistance = planeNormal.dot((Vector3fc)planeOriginToEntity);
        if (((Boolean)this.config.getBackgroundAdaptiveTicking().get()).booleanValue() && (double)signedDistance < -8.75) {
            mode = TickMode.BACKGROUND;
        } else {
            float dX = (float)(camera.method_71156().field_1352 - x);
            float dY = (float)(camera.method_71156().field_1351 - y);
            float dZ = (float)(camera.method_71156().field_1350 - z);
            float squaredDist = dX * dX + dY * dY + dZ * dZ;
            if (squaredDist > (float)this.config.getSlowerTickingDistance()) {
                mode = TickMode.SLOWER;
            } else if (squaredDist > (float)this.config.getSlowTickingDistance()) {
                mode = TickMode.SLOW;
            }
        }
        return mode;
    }

    private void registerDebugEntries() {
        String debugPrefix = String.valueOf(class_124.field_1076) + "[LDL] " + String.valueOf(class_124.field_1070);
        class_2960 debugGroup = LambDynLights.id("debug");
        class_11631.method_72763((class_2960)LambDynLights.id("dynamic_light_sources"), (displayer, level, clientChunk, serverChunk) -> {
            int sourceUpdatedLastTick = 0;
            if (this.chunkRebuildScheduler != null) {
                sourceUpdatedLastTick = this.chunkRebuildScheduler.getSourceUpdatedLastTick();
            }
            StringBuilder builder = new StringBuilder(debugPrefix + "Dynamic Light Sources: ");
            builder.append(this.getLightSourcesCount()).append(" (Occupying ").append(this.engine.getLastEntryCount()).append('/').append(this.engine.getSize()).append(" ; Updated: ").append(sourceUpdatedLastTick);
            if (!this.config.getDynamicLightsMode().isEnabled()) {
                builder.append(" ; ");
                builder.append(class_124.field_1061);
                builder.append("Disabled");
                builder.append(class_124.field_1070);
            }
            builder.append(')');
            displayer.method_72743(debugGroup, builder.toString());
        });
        class_11631.method_72763((class_2960)LambDynLights.id("spatial_lookup"), (displayer, level, clientChunk, serverChunk) -> displayer.method_72743(debugGroup, debugPrefix + "Compute Spatial Lookup Timing: %.3fms (avg. 40t)".formatted(Float.valueOf(this.engine.getComputeSpatialLookupTime() / 1000000.0f))));
        class_11631.method_72763((class_2960)LambDynLights.id("chunk_rebuild_scheduler"), (displayer, level, clientChunk, serverChunk) -> {
            if (this.chunkRebuildScheduler != null) {
                this.chunkRebuildScheduler.appendF3Debug(line -> displayer.method_72743(debugGroup, debugPrefix + line));
            }
        });
        class_11631.method_72763((class_2960)LambDynLights.id("dynamic_light_at_feet"), (displayer, level, clientChunk, serverChunk) -> {
            class_746 player = class_310.method_1551().field_1724;
            if (player != null) {
                displayer.method_72743(debugGroup, debugPrefix + "Dynamic Light At Feet: %.3f".formatted(this.engine.getDynamicLightLevel(player.method_24515())));
            }
        });
    }

    public void onTagsLoaded(class_7225.class_7874 registries) {
        this.itemLightSources.apply(registries);
        this.entityLightSources.apply(registries);
    }

    public void onStartLevelTick() {
        DynamicLightsMode mode = this.config.getDynamicLightsMode();
        this.disableTicking = !mode.isEnabled();
        this.minimumTickMode = mode.tickMode();
        ++this.tick;
    }

    public void onEndLevelTick() {
        class_761 renderer = class_310.method_1551().field_1769;
        this.chunkRebuildScheduler.startTick();
        this.lightSourcesLock.writeLock().lock();
        if (this.config.getDynamicLightsMode().isEnabled()) {
            class_10209.method_64146().method_15396("dynamic_lighting_compute_spatial_lookup");
            this.engine.computeSpatialLookup(this.dynamicLightSources);
            class_10209.method_64146().method_15407();
        }
        this.toClear.forEach(this.chunkRebuildScheduler::remove);
        this.toClear.clear();
        this.lightSourcesLock.writeLock().unlock();
        if (!this.disableTicking || this.shouldForceRefresh) {
            Iterator<DynamicLightSource> it = this.dynamicLightSources.iterator();
            while (it.hasNext()) {
                EntityDynamicLightSource entity;
                DeferredDynamicLightSource deferred;
                DynamicLightBehavior behavior;
                DynamicLightSource lightSource = it.next();
                if (lightSource instanceof DeferredDynamicLightSource && (behavior = (deferred = (DeferredDynamicLightSource)lightSource).behavior()).isRemoved()) {
                    this.toClear.add(lightSource);
                    it.remove();
                    continue;
                }
                if (lightSource instanceof EntityDynamicLightSource && !this.shouldTick(entity = (EntityDynamicLightSource)lightSource) || lightSource instanceof DeferredDynamicLightSource && !this.shouldTick(deferred = (DeferredDynamicLightSource)lightSource)) continue;
                Long2ObjectMap<ChunkRebuildStatus> chunks = lightSource.getDynamicLightChunksToRebuild(this.shouldForceRefresh || this.toAdd.contains(lightSource));
                this.chunkRebuildScheduler.update(lightSource, chunks);
            }
            this.toAdd.clear();
        }
        this.dynamicLightSourcesCount = this.dynamicLightSources.size();
        this.chunkRebuildScheduler.endTick();
        this.sectionRebuildDebugRenderer.tick();
        this.shouldForceRefresh = false;
    }

    public void onEndClientTick(class_310 client) {
        if (TOGGLE_FPS_DYNAMIC_LIGHTING.method_1436()) {
            boolean newValue = (Boolean)this.config.getSelfLightSource().get() == false;
            class_2561 toggleText = SpruceTexts.getToggleText((boolean)newValue);
            this.config.getSelfLightSource().set(newValue);
            this.config.save();
            if (client.field_1724 != null) {
                client.field_1724.method_7353((class_2561)class_2561.method_43469((String)"lambdynlights.key.toggle_fps_dynamic_lighting.info", (Object[])new Object[]{toggleText.method_27661().method_27692(newValue ? class_124.field_1060 : class_124.field_1061)}), true);
            }
        }
    }

    public int getLightmapWithDynamicLight(@NotNull class_1920 level, @NotNull class_2338 pos, int lightmap) {
        if (!(level instanceof class_638)) {
            this.lightSourcesLock.readLock().lock();
        }
        double light = this.getDynamicLightLevel(pos);
        if (!(level instanceof class_638)) {
            this.lightSourcesLock.readLock().unlock();
        }
        return this.getLightmapWithDynamicLight(light, lightmap);
    }

    public int getLightmapWithDynamicLight(double dynamicLightLevel, int lightmap) {
        int blockLevel;
        if (dynamicLightLevel > 0.0 && dynamicLightLevel > (double)(blockLevel = class_765.method_24186((int)lightmap))) {
            int luminance = (int)(dynamicLightLevel * 16.0);
            lightmap &= 0xFFF00000;
            lightmap |= luminance & 0xFFFFF;
        }
        return lightmap;
    }

    public double getDynamicLightLevel(@NotNull class_2338 pos) {
        return this.engine.getDynamicLightLevel(pos);
    }

    public void addLightSource(@NotNull DynamicLightSource lightSource) {
        if (this.containsLightSource(lightSource)) {
            return;
        }
        this.dynamicLightSources.add(lightSource);
        this.toAdd.add(lightSource);
    }

    public boolean containsLightSource(@NotNull DynamicLightSource lightSource) {
        return this.dynamicLightSources.contains(lightSource);
    }

    public int getLightSourcesCount() {
        return this.dynamicLightSources.size();
    }

    public void removeLightSource(@NotNull EntityDynamicLightSourceBehavior lightSource) {
        Iterator<DynamicLightSource> chunkProviders = this.dynamicLightSources.iterator();
        while (chunkProviders.hasNext()) {
            DynamicLightSource it = chunkProviders.next();
            if (!it.equals(lightSource)) continue;
            chunkProviders.remove();
            this.toClear.add(lightSource);
            break;
        }
    }

    public void onChangeWorld(@Nullable class_638 level) {
        Iterator<DynamicLightSource> chunkProviders = this.dynamicLightSources.iterator();
        while (chunkProviders.hasNext()) {
            EntityDynamicLightSource entityIt;
            DynamicLightSource it = chunkProviders.next();
            chunkProviders.remove();
            if (it instanceof EntityDynamicLightSource && (entityIt = (EntityDynamicLightSource)it).getLuminance() > 0) {
                entityIt.resetDynamicLight();
            }
            this.toClear.add(it);
        }
        this.engine.resetSize();
        if (level == null) {
            this.chunkRebuildScheduler = null;
        } else {
            ChunkRebuildScheduler oldChunkRebuildScheduler = this.chunkRebuildScheduler;
            this.chunkRebuildScheduler = this.config.getChunkRebuildSchedulerMode().create(this.sectionRebuildDebugRenderer);
            if (oldChunkRebuildScheduler != null) {
                oldChunkRebuildScheduler.close();
            }
            this.sectionRebuildDebugRenderer.clearRequestedChunks();
        }
    }

    public boolean removeLightSources(@NotNull Predicate<DynamicLightSource> filter) {
        boolean result = false;
        Iterator<DynamicLightSource> dynamicLightSources = this.dynamicLightSources.iterator();
        while (dynamicLightSources.hasNext()) {
            EntityDynamicLightSourceBehavior lightSource;
            DynamicLightSource it = dynamicLightSources.next();
            if (!filter.test(it)) continue;
            dynamicLightSources.remove();
            this.toClear.add(it);
            result = true;
            if (!(it instanceof EntityDynamicLightSourceBehavior) || (lightSource = (EntityDynamicLightSourceBehavior)it).getLuminance() <= 0) continue;
            lightSource.resetDynamicLight();
        }
        return result;
    }

    public boolean canLightParticle(class_703 particle) {
        if (particle instanceof class_10748) {
            return (Boolean)this.config.getFireflyLighting().get();
        }
        return particle instanceof class_7452;
    }

    public static void log(Logger logger, String msg) {
        if (!YumiMods.get().isDevelopmentEnvironment()) {
            msg = "[LambDynLights] " + (String)msg;
        }
        logger.info((String)msg);
    }

    public static void info(Logger logger, String msg, Object ... args) {
        if (!YumiMods.get().isDevelopmentEnvironment()) {
            msg = "[LambDynLights] " + (String)msg;
        }
        logger.info((String)msg, args);
    }

    public static void warn(Logger logger, String msg) {
        if (!YumiMods.get().isDevelopmentEnvironment()) {
            msg = "[LambDynLights] " + (String)msg;
        }
        logger.warn((String)msg);
    }

    public static void warn(Logger logger, String msg, Object ... args) {
        if (!YumiMods.get().isDevelopmentEnvironment()) {
            msg = "[LambDynLights] " + (String)msg;
        }
        logger.warn((String)msg, args);
    }

    public static void error(Logger logger, String msg, Object ... args) {
        if (!YumiMods.get().isDevelopmentEnvironment()) {
            msg = "[LambDynLights] " + (String)msg;
        }
        logger.error((String)msg, args);
    }

    public static void updateTracking(@NotNull EntityDynamicLightSourceBehavior lightSource) {
        boolean enabled = lightSource.isDynamicLightEnabled();
        int luminance = lightSource.getLuminance();
        if (!enabled && luminance > 0) {
            lightSource.setDynamicLightEnabled(true);
        } else if (enabled && luminance < 1) {
            lightSource.setDynamicLightEnabled(false);
        }
    }

    private static boolean isEyeSubmergedInFluid(class_1309 entity) {
        if (!((Boolean)LambDynLights.get().config.getWaterSensitiveCheck().get()).booleanValue()) {
            return false;
        }
        class_2338 eyePos = class_2338.method_49637((double)entity.method_23317(), (double)entity.method_23320(), (double)entity.method_23321());
        return !entity.method_73183().method_8316(eyePos).method_15769();
    }

    public static int getLivingEntityLuminanceFromItems(class_1309 entity) {
        int luminance;
        block2: {
            CompatLayer compat;
            boolean submergedInFluid = LambDynLights.isEyeSubmergedInFluid(entity);
            luminance = 0;
            for (class_1304 equipmentSlot : class_1304.field_54086) {
                class_1799 equipped = entity.method_6118(equipmentSlot);
                if (equipped.method_7960()) continue;
                luminance = Math.max(luminance, LambDynLights.INSTANCE.itemLightSources.getLuminance(equipped, submergedInFluid));
            }
            if (luminance >= 15) break block2;
            Iterator<Object> iterator = CompatLayer.LAYERS.iterator();
            while (iterator.hasNext() && (luminance = Math.max(luminance, (compat = (CompatLayer)iterator.next()).getLivingEntityLuminanceFromItems(LambDynLights.INSTANCE.itemLightSources, entity, submergedInFluid))) != 15) {
            }
        }
        return luminance;
    }

    public static <T extends class_1297> int getLuminanceFrom(T entity) {
        if (!((Boolean)LambDynLights.INSTANCE.config.getEntitiesLightSource().get()).booleanValue()) {
            return 0;
        }
        if (entity == class_310.method_1551().field_1724 && !((Boolean)LambDynLights.INSTANCE.config.getSelfLightSource().get()).booleanValue()) {
            return 0;
        }
        if (!DynamicLightingEngine.canLightUp(entity)) {
            return 0;
        }
        return LambDynLights.INSTANCE.entityLightSources.getLuminance(entity);
    }

    public static LambDynLights get() {
        return INSTANCE;
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)"lambdynlights", (String)path);
    }
}

